<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuCategoryIngredients extends Model 
{

    protected $table = 'menu_category_ingredients';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function menu_category()
    {
        return $this->belongsTo('App\Models\MenuCategory');
    }

    public function ingredient()
    {
        return $this->hasOne('App\Models\Ingredient');
    }

}